/*******************************************************************************
*   touch.h
*   Atmel Corporation:  http://www.atmel.com \n
*   Support email:  touch@atmel.com
******************************************************************************/
/*  License
*   Copyright (c) 2010, Atmel Corporation All rights reserved.
*
*   Redistribution and use in source and binary forms, with or without
*   modification, are permitted provided that the following conditions are met:
*
*   1. Redistributions of source code must retain the above copyright notice,
*   this list of conditions and the following disclaimer.
*
*   2. Redistributions in binary form must reproduce the above copyright notice,
*   this list of conditions and the following disclaimer in the documentation
*   and/or other materials provided with the distribution.
*
*   3. The name of ATMEL may not be used to endorse or promote products derived
*   from this software without specific prior written permission.
*
*   THIS SOFTWARE IS PROVIDED BY ATMEL "AS IS" AND ANY EXPRESS OR IMPLIED
*   WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
*   MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE EXPRESSLY AND
*   SPECIFICALLY DISCLAIMED. IN NO EVENT SHALL ATMEL BE LIABLE FOR ANY DIRECT,
*   INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
*   (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
*   LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
*   ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
*   (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
*   THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/
/*  This is an automatically generated file. Do not modify the contents manually.
    Instead, use the Project Builder Wizard to make changes to the design.
*/
#include <avr/io.h>
#include <avr/interrupt.h>
#include "touch.h"

/*----------------------------------------------------------------------------
                                global variables
----------------------------------------------------------------------------*/
volatile uint8_t tempo_leds, vol_leds;

/*----------------------------------------------------------------------------
                                extern variables
----------------------------------------------------------------------------*/
/* flag set by timer ISR when it's time to measure touch */
extern volatile uint8_t time_to_measure_touch;

/* current time, set by timer ISR */
extern volatile uint16_t current_time_ms_touch;

/* Timer period in msec. */
extern uint16_t qt_measurement_period_msec;
extern uint16_t time_ms_inc;
extern volatile uint16_t clock_time;
extern volatile uint16_t send_time;
extern volatile uint8_t count1 = 0;
extern volatile uint8_t count2 = 0;

#if defined (__ATmega1284P__)
#if defined(_QTOUCH_)
/*============================================================================
Name    :   init_timer_isr
------------------------------------------------------------------------------
Purpose :   configure timer ISR to fire regularly
============================================================================*/
void init_timer_isr( void )
{
    /*  set timer compare value (how often timer ISR will fire) */
    OCR1A = ( TICKS_PER_MS * qt_measurement_period_msec);

    /*  enable timer ISR */
    TIMSK1 |= (1u << OCIE1A);

    /*  timer prescaler = system clock / 8  */
    TCCR1B |= (1u << CS11);

    /*  timer mode = CTC (count up to compare value, then reset)    */
    TCCR1B |= (1u << WGM12);
}

ISR(TIMER1_COMPA_vect)
{	
    /* set flag: it's time to measure touch */
    time_to_measure_touch = 1u;

    /* update the current time */
    current_time_ms_touch += qt_measurement_period_msec;
	
	/* Update send time to send rotor and slider values to MIDI microcontroller */
	if(send_time > 0) send_time--;
	//count1++;
	//count2++;
}

/*============================================================================
Name    :   set_timer_period
------------------------------------------------------------------------------
Purpose :   set the timer period
============================================================================*/
void set_timer_period(uint16_t qt_measurement_period_msec)
{
	OCR1A = ( TICKS_PER_MS * qt_measurement_period_msec);
}

#endif


/*============================================================================
Name    :   init_system
------------------------------------------------------------------------------
Purpose :   Prescale the system clock, disable the JTAG pins and disable
			pull ups.
============================================================================*/
void init_system( void )
{
   /* run at 4MHz */

   asm("ldi r16,0x80");
   asm("sts 0x61,r16");
   asm("ldi r16,0x01");
   asm("sts 0x61,r16");

   /* Disable the JTAG Pins */
   asm("ldi r16,0x80");
   asm("sts 0x55,r16");
   asm("ldi r16,0x80");
   asm("sts 0x55,r16");

   asm("nop");
   asm("nop");

   /* disable pull-ups */
   MCUCR |= (1u << PUD);
}

#endif





